
#ifndef ODDEVEN_SINGER_SMALLOEGENERATOR_HPP
#define ODDEVEN_SINGER_SMALLOEGENERATOR_HPP

#include "AbstractGenerator.hpp"

template<int Q>
class SmallOEGenerator : public AbstractGenerator<Q> {

    using AbstractGenerator<Q>::V;
    using AbstractGenerator<Q>::weights;

protected:
    // check whether the currently generated set should be shipped
    bool shouldBeShipped() const {
        return weights.isOddEven();
    }

    // should a further point be added?
    bool shouldAddPoints() const {
        return true;
    }

    // is this a valid subset of a possible result?
    // (This check is called immediately after adding a point)
    bool isValid() const {
        return true; // weights.largest() <= Q / 2;
    }

    // is this a point that can be added to the current set so that it still remains valid?
    bool isValid(int pt) const {
        return !weights.onHeavyLine(pt);
    }

};


#endif //ODDEVEN_SINGER_SMALLOEGENERATOR_HPP
