#ifndef ODDEVEN_SINGER_SINGERGEOMETRY_H
#define ODDEVEN_SINGER_SINGERGEOMETRY_H

#include "PointLineGeometry.hpp"
#include "Singer.hpp"

////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////

/**
 * The point line geometry of points and lines of the plane,
 * in its Singer cycle representation.
 * Using pt + el ∈ D as incidence relation.
 */
template<int Q>
class SingerGeometry : public PointLineGeometry<Singer<Q>::V, Singer<Q>::V> {

private:
    static constexpr int V = Singer<Q>::V;

    using PointLineGeometry<V,V>::setIncident;

public:
    SingerGeometry();

};

////////////////////////////////////////
// DEFINITIONS
////////////////////////////////////////

template<int Q>
SingerGeometry<Q>::SingerGeometry() : PointLineGeometry<Singer<Q>::V, Singer<Q>::V>() {
    // for each point
    for (int pt = 0; pt < V; ++pt) {
        for (int el: Singer<Q>::D) {
            setIncident(pt, (V + el - pt) % V);
        }
    }
}

#endif //ODDEVEN_SINGER_SINGERGEOMETRY_H
