#ifndef ODDEVEN_SINGER_SIMPLELINESUMGENERATOR_HPP
#define ODDEVEN_SINGER_SIMPLELINESUMGENERATOR_HPP

#include "Weights.hpp"
#include "AbstractGenerator.hpp"


/**
 * Generates sums of lines in the projective plane, for isomorph-free line sets, but only up to 12 lines.
 */
template<int Q>
class SimpleLineSumGenerator : public AbstractGenerator<Q> {

    using AbstractGenerator<Q>::V;
    using AbstractGenerator<Q>::weights;

private:
    Weights<Q> sumSet;
    Archive<ColourablePlane<V>, V> fullArchive{AbstractGenerator<Q>::colourablePlane};

protected:
    // check whether the currently generated set should be shipped
    bool shouldBeShipped() const {
        return true;
    }

    // should a further point be added?
    bool shouldAddPoints() const;

    // is this a valid subset of a possible result?
    // (This check is called immediately after adding a point)
    bool isValid() const {
        return true;
    }

    // is this a point that can be added to the current set so that it still remains valid?
    bool isValid(int pt) const {
        return true;
    }

    // toggle all lines through the given point
    void toggle(int pt);

    void add(int pt) {
        weights.add(pt);
        toggle(pt);
    }

    void remove(int pt) {
        toggle(pt);
        weights.remove(pt);
    }

    int shipSet() const;

public:
    void printStatistics();

/////////////////////////////////////////
// DEFINITIONS
////////////////////////////////////////

};

template<int Q>
bool SimpleLineSumGenerator<Q>::shouldAddPoints() const {
    return weights.size() < 12;
}

template<int Q>
int SimpleLineSumGenerator<Q>::shipSet() const {
/*
    weights.getSet().print('%');
    printf("\n");
*/
    sumSet.getSet().print('%');
    printf("\n");
    return sumSet.size();
}

template<int Q>
void SimpleLineSumGenerator<Q>::toggle(int pt) {
    for (int el: Singer<Q>::D) {
        int ln = (V + el - pt) % V;
        sumSet.toggle(ln);
    }
}

template<int Q>
void SimpleLineSumGenerator<Q>::printStatistics() {
    AbstractGenerator<Q>::printStatistics();
    std::cerr << "Archive size: " << fullArchive.size() << std::endl;
}


#endif //ODDEVEN_SINGER_SIMPLELINESUMGENERATOR_HPP
