#ifndef ODDEVEN_SINGER_SETSGENERATOR_HPP
#define ODDEVEN_SINGER_SETSGENERATOR_HPP

#include "Weights.hpp"
#include "AbstractGenerator.hpp"

/////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////

template<int Q>
class SetsGenerator : public AbstractGenerator<Q>{

    using AbstractGenerator<Q>::V;
    using AbstractGenerator<Q>::weights;

protected:

    // check whether the currently generated set should be shipped
    bool shouldBeShipped() const {
        return true;
    }

    // should a further point be added?
    bool shouldAddPoints() const {
        return weights.size() < V / 2;
    }

    // is this a valid subset of a possible result?
    // (This check is called immediately after adding a point)
    bool isValid() const {
        return true;
    }

    // is this a point that can be added to the current set so that it still remains valid?
    bool isValid(int pt) const {
        return true;
    }

};

#endif //ODDEVEN_SINGER_SETSGENERATOR_HPP
