#ifndef ODDEVEN_LIB_POINTLINEGEOMETRY_H
#define ODDEVEN_LIB_POINTLINEGEOMETRY_H

#include <cstddef>
#include <iostream>
#include <array>

/////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////

/**
 * Represents a geometry of points and lines. The incidence relation between them is stored as an incidence matrix.
 */
template <int V, int B>
class PointLineGeometry {

private:
    std::array<std::array<bool,B>, V> incident{};
    size_t nrOfFlags{0};

public:
    PointLineGeometry() = default;
    void setIncident(int pt, int ln);

public:
    bool isIncident(int pt, int ln) const {
        return incident[pt][ln];
    }

    size_t getNrOfFlags() const {
        return nrOfFlags;
    }

private:
    PointLineGeometry(const PointLineGeometry &other) = delete;
    const PointLineGeometry &operator= (const PointLineGeometry &other) = delete;
};

////////////////////////////////////////
// DEFINITIONS
////////////////////////////////////////

template<int V, int B>
void PointLineGeometry<V,B>::setIncident(int pt, int ln) {
    if (incident[pt][ln] != 0) {
//        std::cerr << "Already incident: " << pt << "," << ln << std::endl;
    } else {
        incident[pt][ln] = true;
        nrOfFlags++;
    }
}

#endif //ODDEVEN_LIB_POINTLINEGEOMETRY_H
