#ifndef ODDEVEN_PARTITION_HPP
#define ODDEVEN_PARTITION_HPP

/////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////

#include <vector>
#include <stdexcept>
#include <iostream>

/**
 * Represents a partition of the set {0,1,...,V-1}
 * @tparam V Number of elements in the set
 */

template<int V>
class Partition : public std::vector<std::vector<int>>{
private:
    std::array<int, V> whichPart;

public:
    Partition();

    // add an element to a partition if not already there
    void add(int part, int el);

    // part nr to which the element belongs or < 0 if none
    int partOf(int el) const {
        return whichPart[el];
    }

    // add a new part to the partition and return its index
    int addPart();

    // check that this really is a partition
    bool isPartition();

    // print to stdout - point numbers are prefixed with the given character
    void print(char prefix) const;

};

template<int V>
bool Partition<V>::isPartition() {
    int i = 0;
    while (i < V && whichPart[i] >= 0) {
        i++;
    }
    return i == V;
}

template<int V>
int Partition<V>::addPart() {
    int s = size();
    push_back({});
    return s;
}

template<int V>
Partition<V>::Partition()  {
    for (int i = 0; i < V; i++) {
        whichPart[i] = -1;
    }
}

template<int V>
void Partition<V>::add(int part, int el) {
    if (whichPart[el] < 0) {
        (*this)[part].push_back(el);
        whichPart[el] = part;
    } else {
        throw std::runtime_error("Element already in partition");
    }
}

template<int V>
void Partition<V>::print(char prefix) const {
  for (const std::vector<int> &part : *this) {
    for (int el : part) {
      std::cout << prefix << el;
    }
    std::cout << std::endl;
  }
}

#endif //ODDEVEN_PARTITION_HPP
