#ifndef ODDEVEN_LIB_COLOURABLEPLANE_HPP
#define ODDEVEN_LIB_COLOURABLEPLANE_HPP

#include "ColourablePLG.hpp"
#include "PointSet.hpp"

////////////////////////////////////////
// DECLARATIONS
////////////////////////////////////////

template<int V>
class ColourablePlane : public ColourablePLG<V, V> {

    using ColourablePLG<V, V>::lab;
    using ColourablePLG<V, V>::ptn;

public:
    ColourablePlane(const PointLineGeometry<V, V> &geometry) : ColourablePLG<V, V>(geometry) {
    }

    void colour(const PointSet<V> &set);

private:
    ColourablePlane() = default;

    ColourablePlane(const ColourablePlane &other) = delete;
    const ColourablePlane &operator = (const ColourablePlane &other) = delete;

};

////////////////////////////////////////
// DEFINITIONS
////////////////////////////////////////

template<int V>
void ColourablePlane<V>::colour(const PointSet<V> &set) {

    // first colour: points in the set
    // second colour: points not in the set
    int pos1 = 0;
    int pos2 = V;
    for (int pt = 0; pt < V; pt++) {
        if (set.contains(pt)) {
            lab[pos1] = pt;
            pos1++;
        } else {
            pos2--;
            lab[pos2] = pt;
        }
    }
    // third colour: lines
    for (int ln = V; ln < 2 * V; ln++) {
        lab[ln] = ln;
    }

    // TODO: use weights to colour the lines? (Nauty will do that for us anyhow)

    for (int &el: ptn) {
        el = 1;
    }
    if (set.getSize() != 0) {
        ptn[set.getSize() - 1] = 0;
    }
    ptn[V - 1] = 0;
    ptn[2 * V - 1] = 0;

}



#endif //ODDEVEN_LIB_COLOURABLEPLANE_HPP
