#include <ctime>
#include <chrono>
#include "singer/SimpleLineSumGenerator.hpp"

/**
 * Generates all sums of lines of the plane, generated by
 * at most 12 lines. Some isomorphism checking is done, but not much.
 */
int main(int argc, char *argv[]) {

    // registering clocks
    std::clock_t startcputime = std::clock();
    auto wcts = std::chrono::system_clock::now();

    // doing all the work
    SimpleLineSumGenerator<ORDER_OF_FIELD> generator;
    generator.processArgs(argc, argv);
    generator.generate();

    // print statistics
    generator.printStatistics();

    // showing time used
    double cpu_duration = (double) (std::clock() - startcputime) / CLOCKS_PER_SEC;
    std::cerr << "Finished in " << cpu_duration << " seconds [CPU Clock] " << std::endl;

    std::chrono::duration<double> wctduration = (std::chrono::system_clock::now() - wcts);
    std::cerr << "Finished in " << wctduration.count() << " seconds [Wall Clock]" << std::endl;

    return 0;
}
