#include <ctime>
#include <chrono>
#include "singer/SetsGenerator.hpp"

/**
 * Generates, up to isomorphism, all subsets of the plane, up to automorphism.
 * Uses the singer cycle representation of the plane.
 */
int main(int argc, char *argv[]) {

    // registering clocks
    std::clock_t startcputime = std::clock();
    auto wcts = std::chrono::system_clock::now();

    // doing all the work
    SetsGenerator<ORDER_OF_FIELD> generator;
    generator.processArgs(argc, argv);
    generator.generate();

    // print statistics
    generator.printStatistics();

    // showing time used
    double cpu_duration = (double) (std::clock() - startcputime) / CLOCKS_PER_SEC;
    std::cerr << "Finished in " << cpu_duration << " seconds [CPU Clock] " << std::endl;

    std::chrono::duration<double> wctduration = (std::chrono::system_clock::now() - wcts);
    std::cerr << "Finished in " << wctduration.count() << " seconds [Wall Clock]" << std::endl;

    return 0;
}
