#include <ctime>
#include <chrono>
#include <iostream>

#include "LineSumGenerator.hpp"

/**
 * Generates, up to isomorphism, all  sums of lines of the plane.
 */
int main(int argc, char *argv[]) {

    // registering clocks
    std::clock_t startcputime = std::clock();
    auto wcts = std::chrono::system_clock::now();

    LineSumGenerator<ORDER_OF_FIELD> generator;
    // add command line arguments as points to the generator
    for (int i = 1; i < argc; ++i) {
        generator.addPoint(std::stoi(argv[i]));
    }
    generator.generate();

    // print statistics
    generator.printStatistics();

    // showing time used
    double cpu_duration = (double) (std::clock() - startcputime) / CLOCKS_PER_SEC;
    std::cerr << "Finished in " << cpu_duration << " seconds [CPU Clock] " << std::endl;

    std::chrono::duration<double> wctduration = (std::chrono::system_clock::now() - wcts);
    std::cerr << "Finished in " << wctduration.count() << " seconds [Wall Clock]" << std::endl;

    return 0;
}
