Generator for odd and even sets in PG(2,8)
===

This is the source code of the generation program used in the paper

* "The odd and even sets of PG(2,8), up to isomorphism", (submitted 2025).

The program is written in C++ and was developed using the CLion IDE which uses
`cmake` as build tool and `clang` as compiler. (It should be possible to rebuild
the software outside of CLion, as long as you have `cmake` and `clang` available.)

#### Main program

The script `genoddeven.sh` generates all odd and even sets in the Desarguesian plane of order 8.
It consists of one line for each of the irreducible even sets.

The program `gensmalloe` generates all irreducible odd and even sets, up to isomorphism.

#### Output format

The program generates some statistics on the *standard error* channel. The sets themselves
are sent to *standard output*, one line per set. Each line
lists the points as numbers terminated by percent signs (e.g. `0%1%2%3%4%5%7%12%14%27%36%42%48%55%56%63%65%66%70%72`). 

The points are
numbered according to their position in the orbit of a Singer cycle: we use the perfect 
difference set representation of the projective plane, i.e., a set of numbers D 
such that all differences a-b, with a,b ∈ D, a≠b are different modulo v = q²+q+1.

E.g q=2, v=7, D={0,1,3}.

* Points are numbered 0..v-1
* Lines are numbered 0..v-1
* Line l contains all points l+a (mod v), a ∈ D
* Point p goes through all lines p-a (mod v), a ∈ D

For q=8 we use D={0, 4, 11, 17, 20, 48, 50, 58, 72}, v=73

#### Depends on Nauty

To be able to compile and run this program, download, install and 'make' a 
[Nauty distribution](https://pallini.di.uniroma1.it/) (currently we are using version `nauty26r12` ). 
Make a softlink to `nauty` in the base directory of this project.

#### Auxiliary programs

Some auxiliary programs, e.g., for conversion to a coordinate representation,
computing he stablizer group size, etc., are available from
the 'minimal blocking set' project, at [https://caagt.ugent.be/bsets/](https://caagt.ugent.be/bsets/).
 
